<?php
error_reporting(0); ini_set('display_errors', 0); require_once __DIR__ . '/Config.php'; require_once SRC_PATH . '/classes/Database.php'; require_once SRC_PATH . '/classes/Game.php'; require_once SRC_PATH . '/controllers/UpgradeController.php'; require_once SRC_PATH . '/controllers/AnonChatController.php'; require_once SRC_PATH . '/classes/LanguageController.php'; require_once SRC_PATH . '/controllers/MissionController.php'; require_once SRC_PATH . '/controllers/CryptoController.php'; require_once SRC_PATH . '/controllers/FileSystemController.php'; session_start(); $languageController = LanguageController::getInstance(); $menuAction = $_GET['action'] ?? ''; if ($menuAction == 'new_game') { Database::resetInstance(); if (file_exists(DB_PATH)) { unlink(DB_PATH); } $domain = isset($_GET['domain']) ? $_GET['domain'] : 'yourtorrent.org'; $db = Database::getInstance(); if (isset($_GET['devmode']) && $_GET['devmode'] == '1') { $_SESSION['devmode_active'] = true; try { $db->query("INSERT OR REPLACE INTO game_state_meta (key_name, value) VALUES ('cheated_save', '1')"); } catch (Exception $e) {} } $db->query("UPDATE game_state SET domain = ? WHERE id = 1", [$domain]); $initialVisitors = mt_rand(5, 15); $db->query( "INSERT INTO competitors (domain, visitors, is_player, rank) VALUES (?, ?, ?, ?)", [$domain, $initialVisitors, 1, 50] ); $db->query("
        UPDATE competitors 
        SET rank = (
            SELECT COUNT(*) + 1 
            FROM competitors AS c2 
            WHERE c2.visitors > competitors.visitors
        )
    "); $_SESSION['from_menu'] = true; $_SESSION['new_game_started'] = true; header('Location: ' . BASE_URL . '/src/utils/Index.php'); exit; } else if ($menuAction == 'load_game') { $_SESSION['from_menu'] = true; if (isset($_GET['devmode']) && $_GET['devmode'] == '1') { $_SESSION['devmode_active'] = true; try { $db = Database::getInstance(); $db->query("INSERT OR REPLACE INTO game_state_meta (key_name, value) VALUES ('cheated_save', '1')"); } catch (Exception $e) {} } header('Location: ' . BASE_URL . '/src/utils/Index.php'); exit; } else if (empty($menuAction) && !isset($_SERVER['HTTP_X_REQUESTED_WITH'])) { if (!isset($_SESSION['from_menu']) || $_SESSION['from_menu'] !== true) { header('Location: ' . BASE_URL . '/src/utils/Menu.php'); exit; } if (!file_exists(DB_PATH)) { header('Location: ' . BASE_URL . '/src/utils/Menu.php'); exit; } } if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') { try { $game = new Game(); $upgrade = new UpgradeController($game); $anonChat = new AnonChatController(); $mission = new MissionController(); $response = []; if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action'])) { $action = $_GET['action']; switch ($action) { case 'getTutorialStatus': $db = Database::getInstance(); $tutorials = $db->query("SELECT * FROM tutorials")->fetchAll(PDO::FETCH_ASSOC); if (empty($tutorials)) { $db->query( "INSERT INTO tutorials (type, step, completed) VALUES ('BASIC', 1, 0)" ); $db->query( "INSERT INTO tutorials (type, step, completed) VALUES ('NODE', 1, 0)" ); $tutorials = $db->query("SELECT * FROM tutorials")->fetchAll(PDO::FETCH_ASSOC); } foreach ($tutorials as $tutorial) { } $response = [ 'success' => true, 'tutorials' => $tutorials ]; break; case 'checkTutorialCondition': $db = Database::getInstance(); $condition = $_GET['condition'] ?? ''; $conditionMet = false; switch ($condition) { case 'purchased': $count = $db->query("SELECT COUNT(*) FROM software WHERE purchased = 1")->fetchColumn(); $conditionMet = $count > 0; break; case 'cracked': $count = $db->query("SELECT COUNT(*) FROM software WHERE cracked = 1")->fetchColumn(); $conditionMet = $count > 0; break; case 'uploaded': $count = $db->query("SELECT COUNT(*) FROM software WHERE uploaded = 1")->fetchColumn(); $conditionMet = $count > 0; break; case 'node_command': $count = $db->query("SELECT COUNT(*) FROM netmap_nodes WHERE active = 0 LIMIT 1")->fetchColumn(); $conditionMet = $count > 0; break; case 'mission_connected': if (!isset($_SESSION['mission_connected'])) { $_SESSION['mission_connected'] = false; } $conditionMet = $_SESSION['mission_connected']; break; case 'mission_help': if (!isset($_SESSION['mission_help_used'])) { $_SESSION['mission_help_used'] = false; } $conditionMet = $_SESSION['mission_help_used']; break; case 'mission_ls': if (!isset($_SESSION['mission_ls_used'])) { $_SESSION['mission_ls_used'] = false; } $conditionMet = $_SESSION['mission_ls_used']; break; case 'mission_cd_home': if (!isset($_SESSION['mission_cd_home_used'])) { $_SESSION['mission_cd_home_used'] = false; } $conditionMet = $_SESSION['mission_cd_home_used']; break; case 'mission_cd_back': if (!isset($_SESSION['mission_cd_back_used'])) { $_SESSION['mission_cd_back_used'] = false; } $conditionMet = $_SESSION['mission_cd_back_used']; break; case 'mission_cd_var_db': if (!isset($_SESSION['mission_cd_var_db_used'])) { $_SESSION['mission_cd_var_db_used'] = false; } $conditionMet = $_SESSION['mission_cd_var_db_used']; break; case 'mission_cat_customers': if (!isset($_SESSION['mission_cat_customers_used'])) { $_SESSION['mission_cat_customers_used'] = false; } $conditionMet = $_SESSION['mission_cat_customers_used']; break; case 'mission_cp_customers': if (!isset($_SESSION['mission_cp_customers_used'])) { $_SESSION['mission_cp_customers_used'] = false; } $conditionMet = $_SESSION['mission_cp_customers_used']; break; case 'mission_complete': $count = $db->query("SELECT COUNT(*) FROM missions WHERE id = 1 AND status = ?", [Mission::STATUS_COMPLETED])->fetchColumn(); $conditionMet = $count > 0; break; default: $conditionMet = false; break; } $response = [ 'success' => true, 'condition' => $condition, 'conditionMet' => $conditionMet ]; break; case 'setLanguage': $lang = isset($_GET['language']) ? $_GET['language'] : ''; $languageController = LanguageController::getInstance(); $success = false; if ($lang && in_array($lang, $languageController->getAvailableLanguages())) { $success = $languageController->setLanguage($lang); } $response = [ 'success' => $success, 'language' => $languageController->getLanguage(), ]; break; default: break; } if (!empty($response)) { header('Content-Type: application/json'); echo json_encode($response); exit; } } $action = $_POST['action'] ?? ''; if ($action === 'clear_session_devmode') { if (isset($_SESSION['devmode_active'])) { unset($_SESSION['devmode_active']); } $response = ['success' => true]; header('Content-Type: application/json'); echo json_encode($response); exit; } switch ($action) { case 'update_game_state': $db = Database::getInstance(); $visitorsInfo = $game->updateVisitorsAndAttention(); $state = $db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $state['credits'] = floor($state['credits']); if (!isset($visitorsInfo['visitors'])) { $visitorsInfo['visitors'] = [ 'current' => $state['current_visitors'], 'capacity' => $state['hosting_level'] * 100, 'satisfaction' => $state['visitor_satisfaction'] ]; } $unreadCount = $anonChat->countUnreadMessages(); if ($unreadCount > 0) { $anonChat->addUnreadMessagesEvent(); } $pendingEvents = []; if (isset($_SESSION['pending_events']) && !empty($_SESSION['pending_events'])) { $pendingEvents = $_SESSION['pending_events']; $_SESSION['pending_events'] = []; } $crypto = new CryptoController($game); $wallet = $crypto->getWalletBalance(); $crypto->updateTsxPriceForCurrentDay(); $crypto->processDailyMining(); $newGameStarted = false; if (isset($_SESSION['new_game_started']) && $_SESSION['new_game_started'] === true) { $newGameStarted = true; unset($_SESSION['new_game_started']); } $firstMissionCompleted = false; if (isset($_SESSION['first_mission_completed']) && $_SESSION['first_mission_completed'] === true) { $firstMissionCompleted = true; unset($_SESSION['first_mission_completed']); } $crackedCount = $db->query("SELECT COUNT(*) as count FROM software WHERE cracked = 1")->fetch(PDO::FETCH_ASSOC)['count']; $uploadedCount = $db->query("SELECT COUNT(*) as count FROM software WHERE uploaded = 1")->fetch(PDO::FETCH_ASSOC)['count']; $response = [ 'success' => true, 'state' => $state, 'visitors_info' => $visitorsInfo, 'anonchat_unread' => $unreadCount, 'pending_events' => $pendingEvents, 'tsx_balance' => $wallet['tsx_balance'], 'new_game_started' => $newGameStarted, 'first_mission_completed' => $firstMissionCompleted, 'software_cracked_count' => $crackedCount, 'software_uploaded_count' => $uploadedCount ]; $manualFlag = '0'; try { $manualFlag = $db->query("SELECT value FROM game_state_meta WHERE key_name = 'server_shutdown_manual' LIMIT 1")->fetchColumn() ?: '0'; } catch (Exception $e) {} $response['server_shutdown_manual'] = ($manualFlag === '1') ? 1 : 0; break; case 'save_event_log': $db = Database::getInstance(); $type = $_POST['type'] ?? 'info'; $message = $_POST['message'] ?? ''; $eventTime = $_POST['event_time'] ?? ''; if (empty($message) || empty($eventTime)) { $response = [ 'success' => false, 'message' => t('ajax.missing_event_data') ]; break; } $db->query( "INSERT INTO event_log (type, message, event_time) VALUES (?, ?, ?)", [$type, $message, $eventTime] ); $eventCount = $db->query("SELECT COUNT(*) as count FROM event_log")->fetch(PDO::FETCH_ASSOC)['count']; if ($eventCount > 50) { $deleteCount = $eventCount - 50; $oldestEvents = $db->query( "SELECT event_id FROM event_log ORDER BY event_id ASC LIMIT ?", [$deleteCount] )->fetchAll(PDO::FETCH_COLUMN); if (!empty($oldestEvents)) { $idList = implode(',', $oldestEvents); $db->query("DELETE FROM event_log WHERE event_id IN ($idList)"); } } $response = [ 'success' => true, 'message' => t('ajax.event_logged') ]; break; case 'get_available_upgrades': $response = ['success' => true, 'upgrades' => $upgrade->getAvailableUpgrades()]; break; case 'purchase_upgrade': $id = $_POST['id'] ?? ''; $response = $upgrade->purchaseUpgrade($id); break; case 'purchase_vpn': $vpnCost = 500; $db = Database::getInstance(); $gameState = $db->query("SELECT credits, vpn_owned FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); if ($gameState['vpn_owned'] == 1) { $response = ['success' => false, 'message' => t('marketplace.vpn.already_owned', 'You already own a VPN package!')]; } elseif ($gameState['credits'] < $vpnCost) { $response = ['success' => false, 'message' => t('marketplace.vpn.insufficient_funds', 'Insufficient funds!')]; } else { $db->query( "UPDATE game_state SET 
                            credits = credits - ?, 
                            vpn_owned = 1, 
                            vpn_capacity = 30, 
                            vpn_max_capacity = 30 
                        WHERE id = 1", [$vpnCost] ); $response = [ 'success' => true, 'message' => t('marketplace.vpn.purchased', 'VPN package purchased! Activate it in VDS missions to reduce trace.'), 'credits' => $gameState['credits'] - $vpnCost ]; } break; case 'get_player_files': $fileSystem = new FileSystemController(); $files = $fileSystem->getPlayerFiles(); $fileCount = $fileSystem->getFileCount(); $totalSize = $fileSystem->getTotalSize(); $response = [ 'success' => true, 'files' => $files, 'file_count' => $fileCount, 'total_size' => $totalSize ]; break; case 'get_file_content': $fileId = isset($_POST['file_id']) ? (int)$_POST['file_id'] : 0; $fileSystem = new FileSystemController(); $file = $fileSystem->getFileContent($fileId); if ($file) { $response = [ 'success' => true, 'file' => $file ]; } else { $response = [ 'success' => false, 'message' => 'File not found' ]; } break; case 'delete_file': $fileId = isset($_POST['file_id']) ? (int)$_POST['file_id'] : 0; $fileSystem = new FileSystemController(); try { $fileSystem->deleteFile($fileId); $response = [ 'success' => true, 'message' => 'File deleted successfully' ]; } catch (Exception $e) { $response = [ 'success' => false, 'message' => 'Error deleting file' ]; } break; case 'calculate_upload_time': $size = floatval($_POST['size'] ?? 0); $uploadTime = $game->calculateUploadTime($size); $response = [ 'success' => true, 'upload_time' => $uploadTime, 'storage_capacity' => $game->getGameState()['storage_capacity'], 'storage_used' => $game->getGameState()['storage_used'] ]; break; case 'get_available_software': $db = Database::getInstance(); $gameState = $db->query("SELECT current_year, vpn_owned FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = $gameState['current_year']; $vpnOwned = $gameState['vpn_owned']; $vpn = $db->query( "SELECT *, ? as is_vpn_owned FROM software WHERE name = 'VPN' AND release_year <= ?", [$vpnOwned, $currentYear] )->fetch(PDO::FETCH_ASSOC); $software = $db->query( "SELECT * FROM software WHERE purchased = 0 AND cracked = 0 AND release_year <= ? AND name != 'VPN' ORDER BY release_year, cost", [$currentYear] )->fetchAll(PDO::FETCH_ASSOC); if ($vpn) { array_unshift($software, $vpn); } $devmodeActive = (isset($_SESSION['devmode_active']) && $_SESSION['devmode_active'] === true) ? 1 : 0; $response = ['success' => true, 'software' => $software, 'devmode_active' => $devmodeActive]; break; case 'get_competitor_rankings': $db = Database::getInstance(); $playerSite = $db->query("SELECT * FROM competitors WHERE is_player = 1")->fetch(PDO::FETCH_ASSOC); if (!$playerSite) { $response = ['success' => false, 'message' => 'Player site not found']; break; } $playerRank = $playerSite['rank']; $startRank = max(1, $playerRank - 2); $endRank = $startRank + 4; $competitorRankings = $db->query( "SELECT * FROM competitors WHERE rank >= ? AND rank <= ? ORDER BY rank ASC LIMIT 5", [$startRank, $endRank] )->fetchAll(PDO::FETCH_ASSOC); if (count($competitorRankings) < 5) { if ($playerRank <= 3) { $competitorRankings = $db->query( "SELECT * FROM competitors ORDER BY rank ASC LIMIT 5" )->fetchAll(PDO::FETCH_ASSOC); } else { $competitorRankings = $db->query( "SELECT * FROM competitors ORDER BY ABS(rank - ?) ASC LIMIT 5", [$playerRank] )->fetchAll(PDO::FETCH_ASSOC); usort($competitorRankings, function($a, $b) { return $a['rank'] - $b['rank']; }); } } $response = [ 'success' => true, 'rankings' => $competitorRankings, 'player_rank' => $playerRank ]; break; case 'update_competitor_visitors': $db = Database::getInstance(); $gameState = $db->query("SELECT current_visitors, current_year, current_month, attention_level, visitor_satisfaction FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); if ($gameState) { $playerSite = $db->query("SELECT * FROM competitors WHERE is_player = 1")->fetch(PDO::FETCH_ASSOC); $playerRank = $playerSite ? $playerSite['rank'] : 50; $db->query( "UPDATE competitors SET visitors = ? WHERE is_player = 1", [$gameState['current_visitors']] ); $year = $gameState['current_year']; $month = $gameState['current_month']; $yearFactor = 1.0; if ($year >= 2000 && $year < 2005) { $yearFactor = 1.0 + (($year - 2000) * 0.1); } elseif ($year >= 2005 && $year < 2010) { $yearFactor = 1.5 + (($year - 2005) * 0.2); } elseif ($year >= 2010 && $year < 2015) { $yearFactor = 2.5 + (($year - 2010) * 0.3); } elseif ($year >= 2015) { $yearFactor = 4.0 + (($year - 2015) * 0.4); } $playerAttention = $gameState['attention_level']; $playerSatisfaction = $gameState['visitor_satisfaction']; $competitors = $db->query( "SELECT * FROM competitors WHERE is_player = 0 ORDER BY rank ASC" )->fetchAll(PDO::FETCH_ASSOC); $marketTrendFactor = (mt_rand(-20, 50) / 1000); $marketSaturationFactor = min(1.0, 1.0 - (($year - 2000) * 0.02)); $specialEventSites = []; $positiveEventCount = mt_rand(0, 2); $negativeEventCount = mt_rand(0, 3); for ($i = 0; $i < $positiveEventCount; $i++) { $specialEventSites[mt_rand(0, count($competitors) - 1)] = 'positive'; } for ($i = 0; $i < $negativeEventCount; $i++) { $specialEventSites[mt_rand(0, count($competitors) - 1)] = 'negative'; } foreach ($competitors as $index => $competitor) { $rankPosition = $competitor['rank']; $rankDiffFromPlayer = abs($rankPosition - $playerRank); $isCloseToPlayer = ($rankPosition < $playerRank && $rankDiffFromPlayer <= 3); $rankNearPlayerFactor = $isCloseToPlayer ? 0.5 : 1.0; $rankFactor = max(0.6, 1.2 - ($rankPosition * 0.015)) * $rankNearPlayerFactor; $visitorsFactor = min(1.5, 0.8 + (log10(max(100, $competitor['visitors'])) * 0.1)); $attentionFactor = max(0.7, 1.0 - ($playerAttention / 250)); $satisfactionFactor = max(1.0, 1.5 - $playerSatisfaction); $baseDailyGrowth = (mt_rand(1, 6)) * $yearFactor * $rankFactor * $visitorsFactor; $siteSpecificFactor = 1.0 + ((mt_rand(-60, 70) / 1000) * (1.2 - $rankFactor)); $visitorChange = $baseDailyGrowth * $siteSpecificFactor * $attentionFactor * $satisfactionFactor * $marketSaturationFactor * (1.0 + $marketTrendFactor); if (isset($specialEventSites[$index])) { if ($specialEventSites[$index] === 'positive') { $boost = mt_rand(120, 300) / 100; $visitorChange *= $boost; } else { $penalty = mt_rand(30, 80) / 100; $visitorChange = -($competitor['visitors'] * $penalty); } } $abandonmentChance = 0.1; if ($rankPosition > 30) { $abandonmentChance += ($rankPosition - 30) * 0.05; } if ($year > 2005) { $abandonmentChance += ($year - 2005) * 0.1; } if (mt_rand(1, 100000) <= $abandonmentChance * 1000) { $lossPercentage = mt_rand(850, 990) / 1000; $visitorChange = -($competitor['visitors'] * $lossPercentage); $percentageValue = $lossPercentage * 100; } else { $negativeGrowthChance = 5 + ($rankPosition * 0.8); if (mt_rand(1, 100) <= $negativeGrowthChance) { $visitorChange = -abs($visitorChange) * (mt_rand(30, 70) / 100); } } $visitorChange = round($visitorChange) + mt_rand(-2, 2); $newVisitors = max(5, $competitor['visitors'] + $visitorChange); $db->query( "UPDATE competitors SET visitors = ?, last_update = CURRENT_TIMESTAMP WHERE id = ?", [$newVisitors, $competitor['id']] ); } $db->query("
                        UPDATE competitors 
                        SET rank = (
                            SELECT COUNT(*) + 1 
                            FROM competitors AS c2 
                            WHERE c2.visitors > competitors.visitors
                        )
                    "); $response = ['success' => true, 'message' => 'Competitor visitors updated successfully']; } else { $response = ['success' => false, 'message' => 'Failed to get game state']; } break; case 'crack_software': $id = $_POST['id'] ?? ''; $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE id = ?", [$id] )->fetch(PDO::FETCH_ASSOC); if ($software) { $db->query( "UPDATE software SET cracked = 1 WHERE id = ?", [$id] ); $attentionIncrease = ($software['popularity'] / 25) + ($software['difficulty'] / 3); $gameState = $db->query("SELECT current_year FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = $gameState['current_year']; $yearScalingFactor = 0.5; if ($currentYear >= 2021) { $yearScalingFactor = 1.5; } else if ($currentYear >= 2016) { $yearScalingFactor = 1.25; } else if ($currentYear >= 2011) { $yearScalingFactor = 1.0; } else if ($currentYear >= 2006) { $yearScalingFactor = 0.75; } $attentionIncrease *= $yearScalingFactor; $db->query( "UPDATE game_state SET attention_level = CASE 
                            WHEN attention_level + ? > 100 THEN 100
                            ELSE attention_level + ?
                        END WHERE id = 1", [$attentionIncrease, $attentionIncrease] ); $response = [ 'success' => true, 'software' => $software, 'attention_increase' => $attentionIncrease ]; } else { $response = ['success' => false, 'message' => t('ajax.software_not_found')]; } break; case 'purchase_software': $id = $_POST['id'] ?? ''; $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE id = ?", [$id] )->fetch(PDO::FETCH_ASSOC); if ($software) { $gameState = $db->query("SELECT credits, vpn_owned, vpn_capacity FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $credits = $gameState['credits']; if ($software['name'] === 'VPN' && $gameState['vpn_owned'] == 1 && $gameState['vpn_capacity'] > 0) { $response = ['success' => false, 'message' => t('ajax.vpn_still_has_capacity')]; break; } if ($credits >= $software['cost']) { $db->query( "UPDATE game_state SET credits = credits - ? WHERE id = 1", [$software['cost']] ); if ($software['name'] === 'VPN') { $db->query( "UPDATE game_state SET vpn_owned = 1, vpn_capacity = 30, vpn_max_capacity = 30, vpn_active = 0 WHERE id = 1" ); } else { $db->query( "UPDATE software SET purchased = 1 WHERE id = ?", [$id] ); } $response = ['success' => true, 'software' => $software]; } else { $response = ['success' => false, 'message' => t('ajax.insufficient_credits')]; } } else { $response = ['success' => false, 'message' => t('ajax.software_not_found')]; } break; case 'get_vpn_refill_cost': $currentTime = time(); $priceTimestamp = $_SESSION['vpn_refill_timestamp'] ?? 0; $timeDiff = $currentTime - $priceTimestamp; if ($timeDiff >= 300 || !isset($_SESSION['vpn_refill_cost'])) { $cost = rand(50, 150); $_SESSION['vpn_refill_cost'] = $cost; $_SESSION['vpn_refill_timestamp'] = $currentTime; } else { $cost = $_SESSION['vpn_refill_cost']; } $response = ['success' => true, 'cost' => $cost]; break; case 'refill_vpn_capacity': $db = Database::getInstance(); $gameState = $db->query("SELECT vpn_owned FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); if ($gameState['vpn_owned'] != 1) { $response = ['success' => false, 'message' => t('ajax.vpn_not_owned')]; break; } $cost = $_SESSION['vpn_refill_cost'] ?? rand(50, 150); $wallet = $db->query("SELECT tsx_balance FROM crypto_wallet WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $tsxBalance = $wallet['tsx_balance'] ?? 0; if ($tsxBalance >= $cost) { $db->query( "UPDATE crypto_wallet SET tsx_balance = tsx_balance - ? WHERE id = 1", [$cost] ); $db->query( "UPDATE game_state SET vpn_capacity = 30, vpn_max_capacity = 30, vpn_active = 0 WHERE id = 1" ); $newBalance = $db->query("SELECT tsx_balance FROM crypto_wallet WHERE id = 1")->fetchColumn(); unset($_SESSION['vpn_refill_cost']); unset($_SESSION['vpn_refill_timestamp']); $response = [ 'success' => true, 'message' => t('ajax.vpn_refilled'), 'tsx_balance' => $newBalance ]; } else { $response = ['success' => false, 'message' => t('ajax.insufficient_tsx')]; } break; case 'get_crackable_software': $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE purchased = 1 AND cracked = 0 ORDER BY difficulty, release_year" )->fetchAll(PDO::FETCH_ASSOC); $response = ['success' => true, 'software' => $software]; break; case 'get_cracking_game': $id = $_POST['id'] ?? ''; $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE id = ? AND purchased = 1 AND cracked = 0", [$id] )->fetch(PDO::FETCH_ASSOC); if ($software) { $hasAutoCrack = false; $autoCrackUpgrade = $db->query( "SELECT * FROM upgrades WHERE type = 'tools' AND acquired = 1 AND effects LIKE '%auto_crack_stage_1%'" )->fetch(PDO::FETCH_ASSOC); if ($autoCrackUpgrade) { $hasAutoCrack = true; } $response = [ 'success' => true, 'software' => $software, 'hasAutoCrack' => $hasAutoCrack ]; } else { $response = ['success' => false, 'message' => t('ajax.software_not_found')]; } break; case 'get_purchased_software': $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE purchased = 1 ORDER BY release_year, name" )->fetchAll(PDO::FETCH_ASSOC); $response = ['success' => true, 'software' => $software]; break; case 'get_cracked_software': $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE cracked = 1 AND uploaded = 0 ORDER BY popularity DESC, release_year DESC" )->fetchAll(PDO::FETCH_ASSOC); $response = ['success' => true, 'software' => $software]; break; case 'get_uploaded_software': $db = Database::getInstance(); $limit = isset($_POST['limit']) ? intval($_POST['limit']) : 10; $software = $db->query( "SELECT * FROM software WHERE uploaded = 1 ORDER BY id DESC LIMIT ?", [$limit] )->fetchAll(PDO::FETCH_ASSOC); $response = ['success' => true, 'software' => $software]; break; case 'delete_uploaded_software': $id = $_POST['id'] ?? ''; $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE id = ? AND uploaded = 1", [$id] )->fetch(PDO::FETCH_ASSOC); if ($software) { $size = floatval($software['size_gb']); $db->query("UPDATE software SET uploaded = 0 WHERE id = ?", [$id]); $gameState = $db->query("SELECT storage_used FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $newStorageUsed = isset($gameState['storage_used']) ? max(0, floatval($gameState['storage_used']) - $size) : 0; $db->query("UPDATE game_state SET storage_used = ? WHERE id = 1", [$newStorageUsed]); $response = [ 'success' => true, 'message' => $software['name'], 'new_storage_used' => $newStorageUsed ]; } else { $response = ['success' => false, 'message' => t('ajax.software_not_found')]; } break; case 'upload_software': $id = $_POST['id'] ?? ''; $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE id = ? AND cracked = 1 AND uploaded = 0", [$id] )->fetch(PDO::FETCH_ASSOC); if ($software) { $gameState = $db->query("SELECT internet_speed FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $internetSpeed = $gameState['internet_speed']; $uploadTime = ceil(($software['size_gb'] * 1024) / $internetSpeed); $response = [ 'success' => true, 'software' => $software, 'upload_time' => max(5, $uploadTime) ]; } else { $response = ['success' => false, 'message' => t('ajax.software_not_found_or_uploaded')]; } break; case 'complete_upload': $id = $_POST['id'] ?? ''; $db = Database::getInstance(); $software = $db->query( "SELECT * FROM software WHERE id = ? AND cracked = 1 AND uploaded = 0", [$id] )->fetch(PDO::FETCH_ASSOC); if ($software) { $gameState = $db->query("SELECT storage_capacity, storage_used FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $newStorageUsed = $gameState['storage_used'] + $software['size_gb']; if ($newStorageUsed <= $gameState['storage_capacity']) { $db->query( "UPDATE software SET uploaded = 1 WHERE id = ?", [$id] ); $db->query( "UPDATE game_state SET storage_used = ? WHERE id = 1", [$newStorageUsed] ); $attentionIncrease = $software['popularity'] / 30; $gameState = $db->query("SELECT current_year FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = $gameState['current_year']; $yearMultiplier = 0.5; if ($currentYear >= 2021) { $yearMultiplier = 2.5; } else if ($currentYear >= 2016) { $yearMultiplier = 2.0; } else if ($currentYear >= 2011) { $yearMultiplier = 1.5; } else if ($currentYear >= 2006) { $yearMultiplier = 1.0; } $attentionIncrease *= $yearMultiplier; $db->query( "UPDATE game_state SET 
                                attention_level = CASE 
                                    WHEN attention_level + ? > 100 THEN 100
                                    ELSE attention_level + ?
                                END
                            WHERE id = 1", [$attentionIncrease, $attentionIncrease] ); $typeMultiplier = 1.0; if ($software['type'] == 'Game' || $software['type'] == 'game') { $typeMultiplier = 2.0; } else if ($software['type'] == 'OS' || $software['type'] == 'os') { $typeMultiplier = 1.5; } $visitors_gained = round($software['popularity'] * 3 * $typeMultiplier * $yearMultiplier); $hostingCapacity = 100; if ($gameState['hosting_level'] > 0) { $hostingCapacity = $gameState['hosting_level'] * 100; } else if (isset($gameState['dedicated_server']) && $gameState['dedicated_server'] > 0) { $hostingCapacity = $gameState['dedicated_server'] * 1000; } $currentState = $db->query("SELECT current_visitors FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentVisitors = $currentState['current_visitors']; $displayableVisitors = min($visitors_gained, $hostingCapacity - $currentVisitors); if ($displayableVisitors < 0) $displayableVisitors = 0; $response = [ 'success' => true, 'message' => $software['name'], 'visitors_gained' => $visitors_gained, 'displayable_visitors' => $displayableVisitors, 'attention_increase' => $attentionIncrease, 'size_gb' => $software['size_gb'], 'new_storage_used' => $newStorageUsed, 'capacity' => $hostingCapacity ]; } else { $response = [ 'success' => false, 'message' => t('ajax.not_enough_storage'), 'storage_available' => $gameState['storage_capacity'] - $gameState['storage_used'], 'file_size' => $software['size_gb'] ]; } } else { $response = ['success' => false, 'message' => t('ajax.software_not_found_or_uploaded')]; } break; case 'get_server_stats': $db = Database::getInstance(); $gameState = $db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $baseSpeed = $gameState['internet_speed']; $actualSpeed = round($baseSpeed * ((mt_rand(90, 110) / 100))); $hostingCapacity = 100; if ($gameState['hosting_level'] > 0) { $hostingCapacity = $gameState['hosting_level'] * 100; } else if ($gameState['dedicated_server'] > 0) { $hostingCapacity = $gameState['dedicated_server'] * 1000; } if (intval($gameState['server_online']) === 0) { $currentVisitors = 0; } else { $currentVisitors = min($gameState['current_visitors'], $hostingCapacity); } if ($currentVisitors < $gameState['current_visitors']) { $db->query("UPDATE game_state SET current_visitors = ? WHERE id = 1", [$currentVisitors]); $gameState['current_visitors'] = $currentVisitors; } $potentialVisitors = $gameState['total_potential_visitors'] ?? $currentVisitors; $userLimit = $gameState['visitor_limit'] ?? 0; $isLimitActive = ($userLimit > 0 && $userLimit <= $hostingCapacity); if ($isLimitActive && $currentVisitors > $userLimit) { $currentVisitors = $userLimit; $db->query("UPDATE game_state SET current_visitors = ? WHERE id = 1", [$currentVisitors]); $gameState['current_visitors'] = $currentVisitors; } $safeSatisfaction = max(0.0, min(1.0, floatval($gameState['visitor_satisfaction']))); $response = [ 'success' => true, 'server_stats' => [ 'hosting_level' => $gameState['hosting_level'], 'hosting_capacity' => $hostingCapacity, 'current_visitors' => $currentVisitors, 'potential_visitors' => $potentialVisitors, 'overflow_percentage' => $potentialVisitors > $hostingCapacity ? round(($potentialVisitors - $hostingCapacity) / $hostingCapacity * 100) : 0, 'internet_speed' => $baseSpeed, 'internet_speed_actual' => $actualSpeed, 'storage_capacity' => $gameState['storage_capacity'], 'storage_used' => $gameState['storage_used'], 'dedicated_server' => $gameState['dedicated_server'], 'visitor_satisfaction' => $safeSatisfaction, 'server_online' => $gameState['server_online'], 'visitor_limit' => $userLimit ] ]; break; case 'update_game_time': $db = Database::getInstance(); $game = new Game(); $formattedDate = $game->updateGameYear(); $updatedState = $game->getGameState(); $currentYear = $updatedState['current_year']; $currentMonth = $updatedState['current_month']; $anonChat = new AnonChatController(); $result = $anonChat->checkForNewMessages($currentYear, $currentMonth); if ($updatedState['current_hour'] == 0 && $updatedState['current_day'] == 1) { require_once SRC_PATH . '/controllers/MissionController.php'; $missionController = new MissionController(); $updatedMissions = $missionController->updateMissionAvailability($currentYear, $currentMonth); if ($updatedMissions > 0) { } $allMissions = $db->query( "SELECT * FROM missions WHERE status IN (?, ?) AND is_available = 1 ORDER BY id ASC", [Mission::STATUS_NOT_STARTED, Mission::STATUS_IN_PROGRESS] )->fetchAll(PDO::FETCH_ASSOC); $currentMonthMission = null; foreach ($allMissions as $mission) { if ($mission['year_available'] == $currentYear && $mission['month_available'] == $currentMonth) { $currentMonthMission = $mission; break; } } if ($currentMonthMission) { $db->query( "UPDATE missions SET is_available = 1, active = 0 WHERE id = ?", [$currentMonthMission['id']] ); } else { } $missionMessages = $anonChat->checkForMissionMessages($currentYear, $currentMonth, $missionController); if (!empty($missionMessages)) { foreach ($missionMessages as $message) { if (!isset($_SESSION['pending_events'])) { $_SESSION['pending_events'] = []; } $_SESSION['pending_events'][] = [ 'type' => 'info', 'message' => t('game.events.new_mission'), 'event_time' => date('H:i') ]; } $firstMission = $db->query( "SELECT * FROM missions WHERE id = 1 AND is_available = 1 AND status = ?", [Mission::STATUS_NOT_STARTED] )->fetch(PDO::FETCH_ASSOC); if ($firstMission && $firstMission['year_available'] == $currentYear && $firstMission['month_available'] == $currentMonth) { $missionTutorial = $db->query( "SELECT * FROM tutorials WHERE type = 'MISSION'" )->fetch(PDO::FETCH_ASSOC); if (!$missionTutorial || $missionTutorial['completed'] == 0) { if (!isset($_SESSION['trigger_mission_tutorial'])) { $_SESSION['trigger_mission_tutorial'] = true; } } } } } $response = [ 'success' => true, 'current_date' => $formattedDate, 'date_string' => $formattedDate, 'current_year' => $updatedState['current_year'], 'current_month' => $updatedState['current_month'], 'current_day' => $updatedState['current_day'], 'current_hour' => $updatedState['current_hour'], 'state' => $updatedState ]; if (isset($_SESSION['trigger_mission_tutorial']) && $_SESSION['trigger_mission_tutorial'] === true) { $response['trigger_mission_tutorial'] = true; unset($_SESSION['trigger_mission_tutorial']); } break; case 'get_game_state': $game = new Game(); $state = $game->getGameState(); $db = Database::getInstance(); $threatsDisabled = '0'; try { $threatsDisabled = $db->query("SELECT value FROM game_state_meta WHERE key_name = 'threats_disabled' LIMIT 1")->fetchColumn() ?: '0'; } catch (Exception $e) {} $response = [ 'success' => true, 'state' => [ 'current_year' => $state['current_year'], 'current_month' => $state['current_month'], 'current_day' => $state['current_day'], 'current_hour' => $state['current_hour'], 'server_online' => isset($state['server_online']) ? $state['server_online'] : 1, 'threats_disabled' => $threatsDisabled === '1' ? 1 : 0, 'devmode_active' => (isset($_SESSION['devmode_active']) && $_SESSION['devmode_active'] === true) ? 1 : 0 ] ]; break; case 'restart_server': $db = Database::getInstance(); $state = $db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentVisitors = $state['current_visitors']; $reducedVisitors = round($currentVisitors * 0.3); $currentPotentialVisitors = $state['total_potential_visitors']; $reducedPotentialVisitors = round($currentPotentialVisitors * 0.3); $currentSatisfaction = floatval($state['visitor_satisfaction']); $reducedSatisfaction = max(0.0, min(1.0, $currentSatisfaction * 0.6)); $currentTime = time(); $keyExists = $db->query("SELECT COUNT(*) FROM game_state_meta WHERE key_name = 'last_restart_time'")->fetchColumn(); if ($keyExists) { $db->query( "UPDATE game_state_meta SET value = ? WHERE key_name = 'last_restart_time'", [$currentTime] ); } else { $db->query( "INSERT INTO game_state_meta (key_name, value) VALUES ('last_restart_time', ?)", [$currentTime] ); } $db->query( "UPDATE game_state SET 
                    server_online = 1, 
                    capacity_dissatisfaction_days = 0,
                    current_visitors = ?,
                    total_potential_visitors = ?,
                    visitor_satisfaction = ?
                    WHERE id = 1", [$reducedVisitors, $reducedPotentialVisitors, $reducedSatisfaction] ); $response = [ 'success' => true, 'message' => t('ajax.server_restarted'), 'previous_visitors' => $currentVisitors, 'current_visitors' => $reducedVisitors, 'previous_potential' => $currentPotentialVisitors, 'current_potential' => $reducedPotentialVisitors, 'previous_satisfaction' => $currentSatisfaction, 'current_satisfaction' => $reducedSatisfaction ]; try { $keyExists = $db->query("SELECT COUNT(*) FROM game_state_meta WHERE key_name = 'server_shutdown_manual'")->fetchColumn(); if ($keyExists) { $db->query("DELETE FROM game_state_meta WHERE key_name = 'server_shutdown_manual'"); } } catch (Exception $e) {} break; case 'shutdown_server': $db = Database::getInstance(); $state = $db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentVisitors = $state['current_visitors']; $reducedVisitors = 0; $currentSatisfaction = floatval($state['visitor_satisfaction']); $reducedSatisfaction = max(0.0, min(1.0, $currentSatisfaction * 0.5)); $db->query( "UPDATE game_state SET 
                        server_online = 0, 
                        capacity_dissatisfaction_days = capacity_dissatisfaction_days + 1,
                        current_visitors = ?,
                        visitor_satisfaction = ?
                    WHERE id = 1", [$reducedVisitors, $reducedSatisfaction] ); $response = [ 'success' => true, 'message' => t('ajax.server_shutdown'), 'previous_visitors' => $currentVisitors, 'current_visitors' => $reducedVisitors, 'previous_satisfaction' => $currentSatisfaction, 'current_satisfaction' => $reducedSatisfaction ]; try { $keyExists = $db->query("SELECT COUNT(*) FROM game_state_meta WHERE key_name = 'server_shutdown_manual'")->fetchColumn(); if ($keyExists) { $db->query("UPDATE game_state_meta SET value = '1' WHERE key_name = 'server_shutdown_manual'"); } else { $db->query("INSERT INTO game_state_meta (key_name, value) VALUES ('server_shutdown_manual', '1')"); } } catch (Exception $e) {} break; case 'process_terminal_command': $command = isset($_POST['command']) ? trim($_POST['command']) : ''; $db = Database::getInstance(); $gameState = $db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $parts = explode(' ', $command); $cmd = strtolower($parts[0]); switch ($cmd) { case 'set_limit': if (count($parts) < 2) { $response = [ 'success' => false, 'message' => t('game.terminal.usage_set_limit') ]; break; } $limit = intval($parts[1]); if ($limit <= 0) { $response = [ 'success' => false, 'message' => t('game.terminal.limit_greater_than_zero') ]; break; } $hostingCapacity = 100; if ($gameState['hosting_level'] > 0) { $hostingCapacity = $gameState['hosting_level'] * 100; } elseif (isset($gameState['dedicated_server']) && $gameState['dedicated_server'] > 0) { $hostingCapacity = $gameState['dedicated_server'] * 1000; } if ($limit > $hostingCapacity) { $response = [ 'success' => false, 'message' => t('game.terminal.limit_exceeds_capacity', ['capacity' => $hostingCapacity]) ]; break; } $db->query( "UPDATE game_state SET visitor_limit = ? WHERE id = 1", [$limit] ); $response = [ 'success' => true, 'message' => t('game.terminal.limit_set_success', ['limit' => $limit]) ]; break; case 'remove_limit': $db->query( "UPDATE game_state SET visitor_limit = 0 WHERE id = 1" ); $response = [ 'success' => true, 'message' => t('game.terminal.limit_removed') ]; break; case 'credits': if (!isset($_SESSION['devmode_active']) || $_SESSION['devmode_active'] !== true) { $response = ['success' => false, 'message' => 'Cheats not enabled. Enable Dev Mode from the menu first.']; break; } if (count($parts) < 2) { $response = ['success' => false, 'message' => 'Usage: credits <amount>']; break; } $value = intval($parts[1]); $value = max(0, min(999999999, $value)); $db->query("UPDATE game_state SET credits = ? WHERE id = 1", [$value]); $response = ['success' => true, 'message' => t('menu.devmode.credits_set', ['amount' => $value])]; break; case 'autocrack': if (!isset($_SESSION['devmode_active']) || $_SESSION['devmode_active'] !== true) { $response = ['success' => false, 'message' => 'Cheats not enabled. Enable Dev Mode with "devmode on" first.']; break; } if (count($parts) < 2) { $response = ['success' => false, 'message' => 'Usage: autocrack <software name>']; break; } $target = trim(substr($command, strlen($parts[0]) + 1)); $affected = 0; $stmt = $db->query("SELECT id FROM software WHERE LOWER(name) = LOWER(?) LIMIT 1", [$target]); $row = $stmt->fetch(PDO::FETCH_ASSOC); if ($row) { $db->query("UPDATE software SET cracked = 1, purchased = 1 WHERE id = ?", [$row['id']]); $affected = 1; } else { $like = '%' . $target . '%'; $stmt2 = $db->query("SELECT id FROM software WHERE LOWER(name) LIKE LOWER(?) LIMIT 1", [$like]); $row2 = $stmt2->fetch(PDO::FETCH_ASSOC); if ($row2) { $db->query("UPDATE software SET cracked = 1, purchased = 1 WHERE id = ?", [$row2['id']]); $affected = 1; } } if ($affected > 0) { $response = ['success' => true, 'message' => t('menu.devmode.autocrack_success', ['name' => $target])]; } else { $response = ['success' => false, 'message' => t('menu.devmode.autocrack_failed', ['name' => $target])]; } break; case 'fastupload': if (!isset($_SESSION['devmode_active']) || $_SESSION['devmode_active'] !== true) { $response = ['success' => false, 'message' => 'Cheats not enabled. Enable Dev Mode with "devmode on" first.']; break; } if (count($parts) < 2) { $response = ['success' => false, 'message' => 'Usage: fastupload <software name>']; break; } $name = trim(substr($command, strlen($parts[0]) + 1)); if ($name === '') { $response = ['success' => false, 'message' => 'Invalid software name']; break; } $foundId = 0; try { $stmt = $db->query("SELECT id FROM software WHERE LOWER(name) = LOWER(?) LIMIT 1", [$name]); $row = $stmt->fetch(PDO::FETCH_ASSOC); if ($row) { $foundId = $row['id']; } } catch (Exception $e) { $foundId = 0; } if (!$foundId) { try { $like = '%' . $name . '%'; $stmt2 = $db->query("SELECT id FROM software WHERE LOWER(name) LIKE LOWER(?) LIMIT 1", [$like]); $row2 = $stmt2->fetch(PDO::FETCH_ASSOC); if ($row2) $foundId = $row2['id']; } catch (Exception $e) { $foundId = 0; } } if ($foundId) { try { $db->query("UPDATE software SET uploaded = 1, purchased = 1 WHERE id = ?", [$foundId]); $response = ['success' => true, 'message' => t('menu.devmode.fastupload_success', ['name' => $name])]; } catch (Exception $e) { $response = ['success' => false, 'message' => t('menu.devmode.fastupload_failed', ['name' => $name])]; } } else { $response = ['success' => false, 'message' => t('menu.devmode.fastupload_failed', ['name' => $name])]; } break; case 'attention': if (!isset($_SESSION['devmode_active']) || $_SESSION['devmode_active'] !== true) { $response = ['success' => false, 'message' => 'Cheats not enabled. Enable Dev Mode from the menu first.']; break; } if (count($parts) < 2) { $response = ['success' => false, 'message' => 'Usage: attention <value>']; break; } $a = floatval($parts[1]); if (!defined('ATTENTION_MAX')) define('ATTENTION_MAX', 100); $a = max(0, min(ATTENTION_MAX, $a)); $db->query("UPDATE game_state SET attention_level = ? WHERE id = 1", [$a]); $response = ['success' => true, 'message' => t('menu.devmode.attention_set', ['value' => $a])]; break; case 'threats': if (!isset($_SESSION['devmode_active']) || $_SESSION['devmode_active'] !== true) { $response = ['success' => false, 'message' => 'Cheats not enabled. Enable Dev Mode from the menu first.']; break; } $sub = isset($parts[1]) ? strtolower($parts[1]) : ''; if ($sub === 'off' || $sub === '0') { $db->query("INSERT OR REPLACE INTO game_state_meta (key_name, value) VALUES ('threats_disabled', '1')"); $response = ['success' => true, 'message' => t('menu.devmode.threats_disabled')]; } else if ($sub === 'on' || $sub === '1') { $db->query("INSERT OR REPLACE INTO game_state_meta (key_name, value) VALUES ('threats_disabled', '0')"); $response = ['success' => true, 'message' => t('menu.devmode.threats_enabled')]; } else { $response = ['success' => false, 'message' => t('menu.devmode.threats_usage')]; } break; case 'date': if (!isset($_SESSION['devmode_active']) || $_SESSION['devmode_active'] !== true) { $response = ['success' => false, 'message' => 'Cheats not enabled. Enable Dev Mode from the menu first.']; break; } if (count($parts) < 2) { $response = ['success' => false]; break; } $dateStr = trim(substr($command, strlen($parts[0]) + 1)); if (preg_match('/^(\d{1,2})\/(\d{1,2})\/(\d{2,4})$/', $dateStr, $m)) { $month = intval($m[1]); $day = intval($m[2]); $year = intval($m[3]); $month = max(1, min(12, $month)); $day = max(1, min(31, $day)); $year = max(1, min(9999, $year)); try { $db->query("UPDATE game_state SET current_month = ?, current_day = ?, current_year = ? WHERE id = 1", [$month, $day, $year]); $response = ['success' => true, 'message' => t('menu.devmode.date_set', ['month' => $month, 'day' => $day, 'year' => $year])]; } catch (Exception $e) { $response = ['success' => false]; } } else { $response = ['success' => false]; } break; case 'cancel_mission': try { $missionController = new MissionController(); $active = $missionController->getActiveMission(); if (!$active) { $response = [ 'success' => false, 'message' => t('missions_api.no_active_mission', 'No active mission to cancel.') ]; } else { $res = $missionController->failMission($active->getId()); if ($res['success']) { $response = [ 'success' => true, 'message' => $res['message'] ]; } else { $response = [ 'success' => false, 'message' => $res['message'] ]; } } } catch (Exception $e) { $response = [ 'success' => false, 'message' => t('missions_api.cancel_failed', 'Failed to cancel the current mission.') ]; } break; default: $response = [ 'success' => false, 'message' => t('game.terminal.unknown_command', ['command' => $cmd]) ]; break; } break; case 'get_ads': $type = isset($_POST['type']) ? $_POST['type'] : 'pending'; require_once SRC_PATH . '/controllers/AdController.php'; $adController = new AdController(); if ($type === 'pending') { $ads = $adController->getPendingAds(); $minutesUntilNextOffer = empty($ads) ? $adController->getMinutesUntilNextOffer() : 0; } else if ($type === 'active') { $ads = $adController->getActiveAds(); } else { $ads = $adController->getCompletedAds(); } $adData = []; foreach ($ads as $ad) { $adData[] = [ 'id' => $ad->getId(), 'name' => $ad->getName(), 'description' => $ad->getDescription(), 'type' => $ad->getType(), 'impression_count' => $ad->getImpressionCount(), 'credit_per_impression' => $ad->getCreditPerImpression(), 'completion_months' => $ad->getCompletionMonths(), 'start_year' => $ad->getStartYear(), 'start_month' => $ad->getStartMonth(), 'end_year' => $ad->getEndYear(), 'end_month' => $ad->getEndMonth(), 'is_accepted' => $ad->getStatus(), 'current_impressions' => $ad->getCurrentImpressions(), 'remaining_impressions' => $ad->getRemainingImpressions(), 'visitor_satisfaction_effect' => $ad->getVisitorSatisfactionEffect(), 'created_at' => $ad->getCreatedAt(), 'expires_at' => $ad->getExpiresAt(), 'total_credit' => $ad->getTotalCredit(), 'completion_percentage' => $ad->getCompletionPercentage(), 'remaining_minutes' => $ad->getRemainingTimeMinutes() ]; } $response = [ 'success' => true, 'ads' => $adData ]; if ($type === 'pending' && empty($ads) && $minutesUntilNextOffer > 0) { $response['next_offer_in_minutes'] = $minutesUntilNextOffer; } break; case 'accept_ad_offer': $adId = isset($_POST['id']) ? (int)$_POST['id'] : 0; require_once SRC_PATH . '/controllers/AdController.php'; $adController = new AdController(); $response = $adController->acceptAdOffer($adId); break; case 'reject_ad_offer': $adId = isset($_POST['id']) ? (int)$_POST['id'] : 0; require_once SRC_PATH . '/controllers/AdController.php'; $adController = new AdController(); $response = $adController->rejectAdOffer($adId); break; case 'cancel_ad_campaign': $adId = isset($_POST['id']) ? intval($_POST['id']) : 0; require_once SRC_PATH . '/controllers/AdController.php'; $adController = new AdController(); $response = $adController->cancelAdCampaign($adId); break; case 'calculate_cancel_penalty': $adId = isset($_POST['id']) ? intval($_POST['id']) : 0; require_once SRC_PATH . '/controllers/AdController.php'; $adController = new AdController(); $response = $adController->calculateCancellationPenalty($adId); break; case 'get_crypto_data': $crypto = new CryptoController($game); $wallet = $crypto->getWalletBalance(); $currentPrice = $crypto->getCurrentTsxPrice(); $priceHistory = $crypto->getPriceHistory(30); $transactions = $crypto->getTransactionHistory(4); $activePcs = $crypto->getActiveMiningPcs(); $miningStatus = $crypto->getMiningStatusAndModifiers(); $response = [ 'success' => true, 'wallet' => $wallet, 'current_price' => $currentPrice, 'price_history' => array_reverse($priceHistory), 'transactions' => $transactions, 'active_pcs' => $activePcs, 'mining' => $miningStatus ]; break; case 'buy_tsx': $creditAmount = floatval($_POST['credit_amount'] ?? 0); if ($creditAmount <= 0) { $response = ['success' => false, 'message' => 'Invalid credit amount']; break; } $crypto = new CryptoController($game); $response = $crypto->buyTsx($creditAmount); break; case 'sell_tsx': $tsxAmount = floatval($_POST['tsx_amount'] ?? 0); if ($tsxAmount <= 0) { $response = ['success' => false, 'message' => 'Invalid TSX amount']; break; } $crypto = new CryptoController($game); $response = $crypto->sellTsx($tsxAmount); break; case 'scan_mining_pcs': $crypto = new CryptoController($game); $response = $crypto->scanForMiningPcs(); break; case 'install_mining_software': $pcId = intval($_POST['pc_id'] ?? 0); if ($pcId <= 0) { $response = ['success' => false, 'message' => 'Invalid PC ID']; break; } $crypto = new CryptoController($game); $response = $crypto->installMiningSoftware($pcId); break; case 'complete_installation': $pcId = intval($_POST['pc_id'] ?? 0); if ($pcId <= 0) { $response = ['success' => false, 'message' => 'Invalid PC ID']; break; } $crypto = new CryptoController($game); $response = $crypto->completeInstallation($pcId); break; case 'process_daily_mining': $crypto = new CryptoController($game); $response = $crypto->processDailyMining(); break; case 'get_event_logs': $db = Database::getInstance(); $limit = isset($_POST['limit']) ? intval($_POST['limit']) : 15; if ($limit < 1) $limit = 15; if ($limit > 50) $limit = 50; $events = $db->query( "SELECT * FROM event_log ORDER BY created_at DESC LIMIT ?", [$limit] )->fetchAll(PDO::FETCH_ASSOC); $response = [ 'success' => true, 'events' => $events ]; break; case 'update_attention': $change = isset($_POST['change']) ? floatval($_POST['change']) : 0; $reason = isset($_POST['reason']) ? $_POST['reason'] : 'NetMap Effect'; $db = Database::getInstance(); $currentAttention = $db->query("SELECT attention_level FROM game_state WHERE id = 1")->fetchColumn(); $newAttention = max(0, min(100, $currentAttention + $change)); $db->query("UPDATE game_state SET attention_level = ? WHERE id = 1", [$newAttention]); $response = [ 'success' => true, 'old_attention' => $currentAttention, 'new_attention' => $newAttention, 'change' => $change ]; break; case 'update_credits': $change = isset($_POST['change']) ? floatval($_POST['change']) : 0; $reason = isset($_POST['reason']) ? $_POST['reason'] : 'NetMap Effect'; $db = Database::getInstance(); $currentCredits = floatval($db->query("SELECT credits FROM game_state WHERE id = 1")->fetchColumn()); $rawNew = $currentCredits + $change; $clamped = max(0, min(999999999, $rawNew)); $newCredits = intval($clamped); $db->query("UPDATE game_state SET credits = ? WHERE id = 1", [$newCredits]); $response = [ 'success' => true, 'old_credits' => $currentCredits, 'new_credits' => $newCredits, 'change' => $change ]; break; case 'update_satisfaction': $change = isset($_POST['change']) ? floatval($_POST['change']) : 0; $reason = isset($_POST['reason']) ? $_POST['reason'] : 'NetMap Effect'; $db = Database::getInstance(); $currentSatisfaction = $db->query("SELECT visitor_satisfaction FROM game_state WHERE id = 1")->fetchColumn(); $newSatisfaction = max(0, min(100, $currentSatisfaction + $change)); $db->query("UPDATE game_state SET visitor_satisfaction = ? WHERE id = 1", [$newSatisfaction]); $response = [ 'success' => true, 'old_satisfaction' => $currentSatisfaction, 'new_satisfaction' => $newSatisfaction, 'change' => $change ]; break; case 'set_attention_and_domain': $db = Database::getInstance(); $attention = isset($_POST['attention']) ? intval($_POST['attention']) : null; $domain = isset($_POST['domain']) ? trim($_POST['domain']) : null; if ($attention === null || $domain === null || $domain === '') { $response = [ 'success' => false, 'message' => 'Missing parameters' ]; break; } $attention = max(0, min(100, $attention)); try { $db->query("UPDATE game_state SET attention_level = ?, domain = ? WHERE id = 1", [$attention, $domain]); $compUpdated = false; try { $db->query("UPDATE competitors SET domain = ? WHERE is_player = 1", [$domain]); $compUpdated = true; } catch (Exception $ce) { $compUpdated = false; } $response = [ 'success' => true, 'message' => 'Updated attention and domain', 'attention' => $attention, 'domain' => $domain, 'competitors_updated' => $compUpdated ]; } catch (Exception $e) { $response = [ 'success' => false, 'message' => 'DB update failed' ]; } break; case 'get_breaking_news': $db = Database::getInstance(); $threshold = isset($_POST['threshold']) ? intval($_POST['threshold']) : 0; $news = $db->query( "SELECT bn.* FROM breaking_news bn 
                    WHERE bn.threshold <= ? 
                    ORDER BY bn.threshold DESC 
                    LIMIT 1", [$threshold] )->fetch(PDO::FETCH_ASSOC); if (!$news) { $response = [ 'success' => false, 'message' => 'No breaking news found for this threshold' ]; break; } $viewed = $db->query( "SELECT id FROM breaking_news_viewed 
                    WHERE news_id = ?", [$news['id']] )->fetch(); $response = [ 'success' => true, 'news' => $news, 'already_viewed' => $viewed ? true : false ]; break; case 'mark_news_viewed': $db = Database::getInstance(); $newsId = isset($_POST['news_id']) ? intval($_POST['news_id']) : 0; if (!$newsId) { $response = [ 'success' => false, 'message' => 'Invalid news ID' ]; break; } $db->query( "INSERT INTO breaking_news_viewed (news_id) VALUES (?)", [$newsId] ); $response = [ 'success' => true, 'message' => 'News marked as viewed' ]; break; case 'save_netmap_node': $db = Database::getInstance(); $gameState = $db->query("SELECT current_year, current_month, server_online FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = $gameState['current_year']; $currentMonth = $gameState['current_month']; if (isset($gameState['server_online']) && intval($gameState['server_online']) === 0) { $response = [ 'success' => false, 'message' => 'Server offline - cannot create netmap node' ]; break; } $nodeId = $_POST['node_id'] ?? ''; $type = $_POST['type'] ?? ''; $name = $_POST['name'] ?? ''; $description = $_POST['description'] ?? ''; $x = isset($_POST['x']) ? floatval($_POST['x']) : 0; $y = isset($_POST['y']) ? floatval($_POST['y']) : 0; $radius = isset($_POST['radius']) ? floatval($_POST['radius']) : 12; $color = $_POST['color'] ?? ''; $pulseColor = $_POST['pulse_color'] ?? ''; $command = $_POST['command'] ?? ''; $icon = $_POST['icon'] ?? ''; $effectType = $_POST['effect_type'] ?? ''; $effectValue = isset($_POST['effect_value']) ? floatval($_POST['effect_value']) : 0; $rewardType = $_POST['reward_type'] ?? ''; $rewardValue = isset($_POST['reward_value']) ? floatval($_POST['reward_value']) : 0; $createdYear = isset($_POST['created_year']) ? intval($_POST['created_year']) : $currentYear; $createdMonth = isset($_POST['created_month']) ? intval($_POST['created_month']) : $currentMonth; $lastEffectYear = isset($_POST['last_effect_year']) ? intval($_POST['last_effect_year']) : $currentYear; $lastEffectMonth = isset($_POST['last_effect_month']) ? intval($_POST['last_effect_month']) : $currentMonth; if (empty($nodeId) || empty($type) || empty($name)) { $response = [ 'success' => false, 'message' => 'Missing required fields for node' ]; break; } $existingNode = $db->query( "SELECT id FROM netmap_nodes WHERE node_id = ?", [$nodeId] )->fetch(); if ($existingNode) { $db->query( "UPDATE netmap_nodes SET 
                        type = ?, name = ?, description = ?, x = ?, y = ?, radius = ?, 
                        color = ?, pulse_color = ?, command = ?, icon = ?,
                        effect_type = ?, effect_value = ?, reward_type = ?, reward_value = ?,
                        active = 1
                        WHERE node_id = ?", [ $type, $name, $description, $x, $y, $radius, $color, $pulseColor, $command, $icon, $effectType, $effectValue, $rewardType, $rewardValue, $nodeId ] ); $response = [ 'success' => true, 'message' => 'Node updated successfully', 'node_id' => $nodeId ]; } else { $db->query( "INSERT INTO netmap_nodes (
                            node_id, type, name, description, x, y, radius, 
                            color, pulse_color, command, icon,
                            effect_type, effect_value, reward_type, reward_value,
                            created_year, created_month, last_effect_year, last_effect_month
                        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [ $nodeId, $type, $name, $description, $x, $y, $radius, $color, $pulseColor, $command, $icon, $effectType, $effectValue, $rewardType, $rewardValue, $createdYear, $createdMonth, $lastEffectYear, $lastEffectMonth ] ); $newNode = $db->query( "SELECT * FROM netmap_nodes WHERE node_id = ?", [$nodeId] )->fetch(PDO::FETCH_ASSOC); $response = [ 'success' => true, 'message' => 'Node created successfully', 'node_id' => $nodeId, 'node_data' => $newNode ]; } break; case 'get_netmap_nodes': $db = Database::getInstance(); $nodes = $db->query( "SELECT * FROM netmap_nodes WHERE active = 1 ORDER BY created_at DESC" )->fetchAll(PDO::FETCH_ASSOC); $response = [ 'success' => true, 'nodes' => $nodes ]; break; case 'update_netmap_node': $db = Database::getInstance(); $nodeId = $_POST['node_id'] ?? ''; $active = isset($_POST['active']) ? (int)$_POST['active'] : 1; $accumulated = isset($_POST['accumulated_effect']) ? floatval($_POST['accumulated_effect']) : null; if (empty($nodeId)) { $response = [ 'success' => false, 'message' => 'Node ID is required' ]; break; } $updateFields = []; $params = []; $updateFields[] = 'active = ?'; $params[] = $active; if ($accumulated !== null) { $updateFields[] = 'accumulated_effect = ?'; $params[] = $accumulated; } $params[] = $nodeId; $db->query( "UPDATE netmap_nodes SET " . implode(', ', $updateFields) . " WHERE node_id = ?", $params ); $response = [ 'success' => true, 'message' => 'Node updated successfully' ]; break; case 'apply_netmap_effects': $db = Database::getInstance(); $current_state = $db->query("SELECT current_year, current_month FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $current_year = $current_state['current_year']; $current_month = $current_state['current_month']; $debug_info = [ 'current_year' => $current_year, 'current_month' => $current_month ]; $nodes = $db->query( "SELECT * FROM netmap_nodes WHERE active = 1 AND type != 'STATIC' AND 
                    (last_effect_year < ? OR (last_effect_year = ? AND last_effect_month < ?))", [$current_year, $current_year, $current_month] )->fetchAll(PDO::FETCH_ASSOC); $debug_info['active_nodes_count'] = count($nodes); $debug_info['nodes_processed'] = []; $effects_applied = []; foreach ($nodes as $node) { $effect_type = $node['effect_type']; $effect_value = floatval($node['effect_value']); $accumulated_effect = floatval($node['accumulated_effect']) + $effect_value; $db->query( "UPDATE netmap_nodes SET last_effect_year = ?, last_effect_month = ?, accumulated_effect = ? WHERE node_id = ?", [$current_year, $current_month, $accumulated_effect, $node['node_id']] ); $updated_node = $db->query( "SELECT accumulated_effect FROM netmap_nodes WHERE node_id = ?", [$node['node_id']] )->fetch(PDO::FETCH_ASSOC); $debug_info['nodes_processed'][] = [ 'node_id' => $node['node_id'], 'name' => $node['name'], 'type' => $node['type'], 'effect_type' => $effect_type, 'effect_value' => $effect_value, 'previous_accumulated' => $node['accumulated_effect'], 'new_accumulated' => $updated_node['accumulated_effect'], 'updated_successfully' => $updated_node['accumulated_effect'] == $accumulated_effect ]; if ($effect_type && $effect_value) { $game->handleNetMapEffect($effect_type, $effect_value, "Monthly effect from {$node['name']}"); $effects_applied[] = [ 'node_id' => $node['node_id'], 'name' => $node['name'], 'effect_type' => $effect_type, 'effect_value' => $effect_value, 'accumulated_effect' => $accumulated_effect ]; } } $response = [ 'success' => true, 'message' => 'NetMap effects applied successfully', 'effects_applied' => $effects_applied, 'debug_info' => $debug_info ]; break; case 'get_active_node_counts': $db = Database::getInstance(); $total_active = $db->query( "SELECT COUNT(*) as count FROM netmap_nodes WHERE active = 1 AND type != 'STATIC'" )->fetch(PDO::FETCH_ASSOC)['count']; $type_counts = []; $node_types = ['portscan', 'dataleak', 'botnet']; foreach ($node_types as $type) { $count = $db->query( "SELECT COUNT(*) as count FROM netmap_nodes WHERE active = 1 AND LOWER(type) = ?", [strtolower($type)] )->fetch(PDO::FETCH_ASSOC)['count']; $type_counts[$type] = intval($count); } $response = [ 'success' => true, 'total_active' => intval($total_active), 'counts' => $type_counts ]; break; case 'delete_netmap_node': $db = Database::getInstance(); $nodeId = $_POST['node_id'] ?? ''; if (empty($nodeId)) { $response = [ 'success' => false, 'message' => 'Node ID is required for deletion' ]; break; } $existingNode = $db->query( "SELECT id, name FROM netmap_nodes WHERE node_id = ?", [$nodeId] )->fetch(PDO::FETCH_ASSOC); if (!$existingNode) { $response = [ 'success' => false, 'message' => 'Node not found' ]; break; } $db->query( "DELETE FROM netmap_nodes WHERE node_id = ?", [$nodeId] ); $response = [ 'success' => true, 'message' => 'Node deleted successfully', 'node_id' => $nodeId, 'node_name' => $existingNode['name'] ]; break; case 'get_anonchat_messages': $messages = $anonChat->getAllMessages(); $messageData = []; $gameState = $game->getGameState(); $currentYear = $gameState['current_year']; $currentMonth = $gameState['current_month']; foreach ($messages as $message) { $messageYear = $message->getYear() ?: $currentYear; $messageMonth = $message->getMonth() ?: $currentMonth; $messageData[] = [ 'id' => $message->getId(), 'title' => $message->getTitle(), 'message' => $message->getMessage(), 'content' => $message->getMessage(), 'read' => $message->getIsRead() == 1, 'is_read' => $message->getIsRead(), 'folder' => $message->getFolder(), 'date' => sprintf('%04d-%02d-%02d', $messageYear, $messageMonth, 1), 'created_at' => $message->getCreatedAt() ]; } $response = [ 'success' => true, 'messages' => $messageData ]; break; case 'get_anonchat_folder': $folder = $_POST['folder'] ?? 'inbox'; $messages = $anonChat->getMessagesInFolder($folder); $messageData = []; $gameState = $game->getGameState(); $currentYear = $gameState['current_year']; $currentMonth = $gameState['current_month']; foreach ($messages as $message) { $messageYear = $message->getYear() ?: $currentYear; $messageMonth = $message->getMonth() ?: $currentMonth; $messageData[] = [ 'id' => $message->getId(), 'title' => $message->getTitle(), 'message' => $message->getMessage(), 'content' => $message->getMessage(), 'read' => $message->getIsRead() == 1, 'is_read' => $message->getIsRead(), 'folder' => $message->getFolder(), 'date' => sprintf('%04d-%02d-%02d', $messageYear, $messageMonth, 1), 'created_at' => $message->getCreatedAt() ]; } $response = [ 'success' => true, 'messages' => $messageData, 'folder' => $folder ]; break; case 'move_anonchat_message': $id = $_POST['id'] ?? 0; $folder = $_POST['folder'] ?? 'inbox'; if (!in_array($folder, ['inbox', 'archive', 'deleted'])) { $folder = 'inbox'; } $success = $anonChat->moveMessageToFolder($id, $folder); $response = [ 'success' => $success, 'message' => $success ? 'Message moved to ' . $folder : 'Failed to move message' ]; break; case 'get_unread_messages': $messages = $anonChat->getUnreadMessages(); $messageData = []; foreach ($messages as $message) { $messageData[] = [ 'id' => $message->getId(), 'title' => $message->getTitle(), 'message' => $message->getMessage(), 'created_at' => $message->getCreatedAt() ]; } $response = [ 'success' => true, 'messages' => $messageData, 'count' => count($messageData) ]; break; case 'read_message': $id = $_POST['id'] ?? 0; $success = $anonChat->markMessageAsRead($id); if ($success) { $response = [ 'success' => true, 'message' => 'Message marked as read' ]; } else { $response = [ 'success' => false, 'message' => 'Failed to mark message as read' ]; } break; case 'check_new_messages': $gameState = $game->getGameState(); $currentYear = $gameState['current_year']; $currentMonth = $gameState['current_month']; $db = Database::getInstance(); $newMessages = AnonChat::checkForNewMessages($db, $currentYear, $currentMonth); if (count($newMessages) > 0) { $anonChat->addUnreadMessagesEvent(); } $response = [ 'success' => true, 'new_messages' => count($newMessages) > 0, 'unread_count' => $anonChat->countUnreadMessages() ]; break; case 'mark_all_anonchat_messages_as_read': $messages = $anonChat->getUnreadMessages(); $success = true; foreach ($messages as $message) { $success = $success && $anonChat->markMessageAsRead($message->getId()); } $db = Database::getInstance(); $db->query( "UPDATE game_state_meta SET value = '0' WHERE key_name = 'last_reported_unread_count'" ); $response = [ 'success' => $success, 'unread_count' => $anonChat->countUnreadMessages() ]; break; case 'get_unread_message_count': $unreadCount = $anonChat->countUnreadMessages(); $response = [ 'success' => true, 'unread_count' => $unreadCount ]; break; case 'get_forum_topics': $db = Database::getInstance(); $gameState = $db->query("SELECT current_year, current_month, current_visitors FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = $gameState['current_year']; $currentMonth = $gameState['current_month']; $visitors = $gameState['current_visitors']; $currentQuarter = ceil($currentMonth / 3); $uploadedSoftwareCount = $db->query("SELECT COUNT(*) as count FROM software WHERE uploaded = 1")->fetch(PDO::FETCH_ASSOC)['count']; $forumTopics = []; $debugInfo = [ 'current_year' => $currentYear, 'current_month' => $currentMonth, 'current_quarter' => $currentQuarter, 'visitors' => $visitors, 'uploaded_software_count' => $uploadedSoftwareCount, 'has_visitors' => $visitors > 0 ? 'true' : 'false', 'has_software' => $uploadedSoftwareCount > 0 ? 'true' : 'false', 'conditions_met' => ($visitors > 0 && $uploadedSoftwareCount > 0) ? 'true' : 'false' ]; if ($visitors > 0 && $uploadedSoftwareCount > 0) { $forumTopics = $db->query( "SELECT id, title, content, user_name, is_harmful, status, year, month 
                        FROM forum_topics 
                        WHERE year = ? AND quarter = ? AND is_moderated = 0
                        ORDER BY id ASC 
                        LIMIT 15", [$currentYear, $currentQuarter] )->fetchAll(PDO::FETCH_ASSOC); if (empty($forumTopics)) { $existingTopicsCount = $db->query( "SELECT COUNT(*) as count FROM forum_topics WHERE year = ? AND quarter = ?", [$currentYear, $currentQuarter] )->fetch(PDO::FETCH_ASSOC)['count']; $debugInfo['existing_topics_count'] = $existingTopicsCount; if ($existingTopicsCount == 0) { $baseTopicCount = min(20, max(5, floor($visitors / 100))); $yearFactor = ($currentYear - 2000) / 15; $topicCount = floor($baseTopicCount * (1 + $yearFactor)); $debugInfo['generating_topics'] = 'true'; $debugInfo['topic_count'] = $topicCount; $game->generateForumTopics($currentYear, $currentMonth, $currentQuarter, $topicCount); $forumTopics = $db->query( "SELECT id, title, content, user_name, is_harmful, status, year, month 
                                FROM forum_topics 
                                WHERE year = ? AND quarter = ? AND is_moderated = 0
                                ORDER BY id ASC
                                LIMIT 15", [$currentYear, $currentQuarter] )->fetchAll(PDO::FETCH_ASSOC); } else { $debugInfo['all_topics_moderated'] = 'true'; } } } if (empty($forumTopics)) { $allModerated = $db->query( "SELECT COUNT(*) as count FROM forum_topics WHERE year = ? AND quarter = ? AND is_moderated = 1", [$currentYear, $currentQuarter] )->fetch(PDO::FETCH_ASSOC)['count']; $debugInfo['all_moderated'] = $allModerated > 0 ? 'true' : 'false'; $debugInfo['wait_for_next_quarter'] = $allModerated > 0 ? 'true' : 'false'; } $response = [ 'success' => true, 'topics' => $forumTopics, 'debug_info' => $debugInfo ]; break; case 'moderate_forum_topic': $id = intval($_POST['id'] ?? 0); $action = $_POST['topic_action'] ?? ''; if ($id <= 0 || !in_array($action, ['approve', 'reject'])) { $response = ['success' => false, 'message' => 'Invalid topic ID or action']; break; } $db = Database::getInstance(); $topic = $db->query( "SELECT id, is_harmful, effect_value FROM forum_topics WHERE id = ?", [$id] )->fetch(PDO::FETCH_ASSOC); if (!$topic) { $response = ['success' => false, 'message' => 'Topic not found']; break; } $newStatus = ($action == 'approve') ? 1 : 2; $db->query( "UPDATE forum_topics SET status = ?, is_moderated = 1 WHERE id = ?", [$newStatus, $id] ); $satisfactionEffect = 0; if ($action == 'approve') { $satisfactionEffect = $topic['effect_value']; } else { $satisfactionEffect = $topic['is_harmful'] ? abs($topic['effect_value'] * 0.3) : -abs($topic['effect_value'] * 0.3); } $db->query( "UPDATE game_state SET visitor_satisfaction = CASE
                        WHEN visitor_satisfaction + ? > 1.0 THEN 1.0
                        WHEN visitor_satisfaction + ? < 0.1 THEN 0.1
                        ELSE visitor_satisfaction + ?
                    END WHERE id = 1", [$satisfactionEffect, $satisfactionEffect, $satisfactionEffect] ); $response = [ 'success' => true, 'message' => 'Topic moderated successfully', 'satisfaction_effect' => $satisfactionEffect ]; break; case 'autoprocess_forum_topics': $db = Database::getInstance(); $gameState = $db->query("SELECT current_year, current_month FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = $gameState['current_year']; $currentMonth = $gameState['current_month']; $currentQuarter = ceil($currentMonth / 3); $isNewQuarter = ($currentMonth % 3 == 1); if ($isNewQuarter) { $previousQuarter = $currentQuarter == 1 ? 4 : $currentQuarter - 1; $previousYear = $currentQuarter == 1 ? $currentYear - 1 : $currentYear; $db->query( "UPDATE forum_topics SET status = 3, is_moderated = 1 
                        WHERE year = ? AND quarter = ? AND is_moderated = 0", [$previousYear, $previousQuarter] ); } $response = ['success' => true]; break; case 'toggle_vpn': $db = Database::getInstance(); $vpnState = $db->query( "SELECT vpn_owned, vpn_active, vpn_capacity FROM game_state WHERE id = 1" )->fetch(PDO::FETCH_ASSOC); if (!$vpnState || $vpnState['vpn_owned'] != 1) { $response = ['success' => false, 'message' => t('ajax.vpn.not_owned', 'You need to purchase a VPN package first!')]; } elseif ($vpnState['vpn_capacity'] <= 0) { $response = ['success' => false, 'message' => t('game.marketplace.vpn.depleted', 'VPN capacity depleted! Purchase a new package.')]; } else { $newState = $vpnState['vpn_active'] == 1 ? 0 : 1; $db->query("UPDATE game_state SET vpn_active = ? WHERE id = 1", [$newState]); $response = [ 'success' => true, 'vpn_active' => $newState, 'vpn_capacity' => $vpnState['vpn_capacity'], 'message' => $newState == 1 ? t('game.marketplace.vpn.activated', 'VPN activated! Trace reduction active.') : t('game.marketplace.vpn.deactivated', 'VPN deactivated.') ]; } break; case 'get_vpn_status': $db = Database::getInstance(); $vpnState = $db->query( "SELECT vpn_owned, vpn_active, vpn_capacity, vpn_max_capacity FROM game_state WHERE id = 1" )->fetch(PDO::FETCH_ASSOC); $response = ['success' => true, 'vpn' => $vpnState]; break; case 'get_available_missions': $gameState = $game->getGameState(); $missions = $mission->getAvailableMissions($gameState['current_year'], $gameState['current_month']); $missionsArray = []; foreach ($missions as $m) { $missionsArray[] = $m->toArray(); } $response = [ 'success' => true, 'missions' => $missionsArray ]; break; case 'start_mission': $missionId = $_POST['mission_id'] ?? ''; if (empty($missionId)) { $response = [ 'success' => false, 'message' => 'Missing mission ID' ]; break; } $result = $mission->startMission($missionId); if ($result['success']) { $_SESSION['active_mission_id'] = $missionId; $response = [ 'success' => true, 'redirect' => 'src/utils/Vds.php' ]; } else { $response = $result; } break; case 'mission_command': $command = $_POST['command'] ?? ''; $missionId = $_SESSION['active_mission_id'] ?? ''; if (empty($command) || empty($missionId)) { $response = [ 'success' => false, 'message' => 'Missing required parameters' ]; break; } $response = [ 'success' => true, 'command' => $command, 'output' => 'Command not implemented yet: ' . $command ]; break; case 'delete_game_database': if (method_exists('Database', 'closeConnection')) { Database::closeConnection(); } if (isset($_POST['db_path']) && !empty($_POST['db_path'])) { $pathToDelete = $_POST['db_path']; } else { $pathToDelete = defined('DB_PATH') ? DB_PATH : null; } if (!$pathToDelete) { $response = ['success' => false, 'message' => 'No path provided']; break; } $deleted = false; if (file_exists($pathToDelete)) { try { if (unlink($pathToDelete)) { $deleted = true; } } catch (Exception $e) { } } if ($deleted) { $response = ['success' => true, 'message' => 'Deleted successfully']; } else { $response = ['success' => false, 'message' => 'Delete failed', 'path' => $pathToDelete]; } break; case 'updateTutorialProgress': $type = $_POST['type'] ?? ''; $step = intval($_POST['step'] ?? 1); if (empty($type)) { $response = [ 'success' => false, 'message' => 'Tutorial type is required' ]; break; } $db = Database::getInstance(); $tutorial = $db->query( "SELECT id FROM tutorials WHERE type = ?", [$type] )->fetch(PDO::FETCH_ASSOC); if (!$tutorial) { $db->query( "INSERT INTO tutorials (type, step, completed) VALUES (?, ?, 0)", [$type, $step] ); } else { $db->query( "UPDATE tutorials SET step = ? WHERE type = ?", [$step, $type] ); $updatedStep = $db->query( "SELECT step FROM tutorials WHERE type = ?", [$type] )->fetchColumn(); } $response = [ 'success' => true, 'message' => 'Tutorial progress updated successfully', 'type' => $type, 'step' => $step ]; break; case 'completeTutorial': $type = $_POST['type'] ?? ''; if (empty($type)) { $response = [ 'success' => false, 'message' => 'Tutorial type is required' ]; break; } $db = Database::getInstance(); $tutorial = $db->query( "SELECT id FROM tutorials WHERE type = ?", [$type] )->fetch(PDO::FETCH_ASSOC); if (!$tutorial) { $db->query( "INSERT INTO tutorials (type, step, completed, completed_at) VALUES (?, ?, 1, CURRENT_TIMESTAMP)", [$type, 1] ); } else { $db->query( "UPDATE tutorials SET completed = 1, completed_at = CURRENT_TIMESTAMP WHERE type = ?", [$type] ); $completed = $db->query( "SELECT completed FROM tutorials WHERE type = ?", [$type] )->fetchColumn(); } $response = [ 'success' => true, 'message' => 'Tutorial marked as completed', 'type' => $type ]; break; } header('Content-Type: application/json'); echo json_encode($response); exit; } catch (Exception $e) { header('Content-Type: application/json'); echo json_encode([ 'success' => false, 'message' => 'An error occurred: ' . $e->getMessage() ]); exit; } } ?>
<!DOCTYPE html>
<html lang="<?php echo $languageController->getLanguage(); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title data-i18n="game.title">Torrent Empire</title>
    <link rel="stylesheet" href="<?php echo PUBLIC_URL; ?>/css/style.css">
    <link rel="stylesheet" href="<?php echo PUBLIC_URL; ?>/css/netmap.css">
    <link rel="stylesheet" href="<?php echo PUBLIC_URL; ?>/css/cracksystem.css">

    <script>
        window.BASE_URL = '<?php echo BASE_URL; ?>';
        window.ASSETS_URL = '<?php echo ASSETS_URL; ?>';
        window.PUBLIC_URL = '<?php echo PUBLIC_URL; ?>';
        window.API_URL = '<?php echo API_URL; ?>';
        window.LANGUAGES_URL = '<?php echo LANGUAGES_URL; ?>';
    </script>
    <script src="<?php echo PUBLIC_URL; ?>/js/language.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/discord.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/sound.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/news.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/netmap.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/cat.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/cracksystem.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/game.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/tutorial.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/protection.js"></script>
    <script>
    (function(){
        try {
            const val = localStorage.getItem('effects_enabled');
            if (val === '0' || val === 'false') {
                document.documentElement.classList.add('effects-disabled');

                try {
                    const applyToCrt = (el) => {
                        try {
                            el.classList.add('effects-disabled');
                            el.setAttribute('data-effects-disabled', '1');
                        } catch(e) {}
                    };

                    const crtContainer = document.querySelector('.crt-container');
                    if (crtContainer) {
                        applyToCrt(crtContainer);
                    } else {
                        try {
                            const crtObserver = new MutationObserver((mutations, obs) => {
                                for (const m of mutations) {
                                    for (const n of m.addedNodes) {
                                        if (!(n instanceof Element)) continue;
                                        if (n.matches && n.matches('.crt-container')) {
                                            applyToCrt(n);
                                            obs.disconnect();
                                            return;
                                        }
                                    }
                                }
                            });
                            crtObserver.observe(document.documentElement, { childList: true, subtree: true });
                            setTimeout(() => { try { crtObserver.disconnect(); } catch(e){} }, 5000);
                        } catch(e) {}
                    }
                } catch(e) {}

                const classes = ['crt-glitch','crt-flicker','flicker','color-shift','crt-noise','scan-line','scan-lines','scan-animation','scan-wave','screen-shake'];
                const sel = classes.map(c => '.' + c).join(', ');

                const hideNode = (el) => {
                    if (!el || el.dataset.effectsDisabled) return;
                    try {
                        el.style.animation = 'none';
                        el.style.webkitAnimation = 'none';
                        el.style.opacity = '0';
                        el.style.boxShadow = 'none';
                        el.style.pointerEvents = 'none';
                        el.dataset.effectsDisabled = '1';
                    } catch (e) {}
                };

                const hideEffects = (root = document) => {
                    try {
                        const list = root.querySelectorAll(sel);
                        list.forEach(hideNode);
                    } catch (e) {}
                };

                hideEffects();

                try {
                    let moTimer = null;
                    const mo = new MutationObserver((mutations) => {
                        if (moTimer) return;
                        moTimer = setTimeout(() => {
                            moTimer = null;
                            for (const mut of mutations) {
                                for (const node of mut.addedNodes) {
                                    if (!(node instanceof Element)) continue;
                                    try {
                                        if (node.matches && node.matches(sel)) hideNode(node);
                                    } catch (e) {}
                                    hideEffects(node);
                                }
                            }
                        }, 50);
                    });
                    mo.observe(document.documentElement, { childList: true, subtree: true });
                } catch (e) {}
            }
        } catch(e) {}
    })();

    document.addEventListener('DOMContentLoaded', function() {
        const serverLang = '<?php echo $languageController->getLanguage(); ?>';
        if (window.langManager && serverLang) {
            window.langManager.loadLanguage(serverLang);
        }
        
        if (window.DiscordRPC && window.DiscordRPC.isAvailable()) {
            window.DiscordRPC.setPlayingPresence();
        }
    });
    </script>
</head>
<body>
    <div class="crt-container">
        <div class="scan-lines"></div>
        <div class="scan-line"></div>
        <div class="crt-flicker"></div>
        <div class="crt-vignette"></div>
        <div class="crt-noise"></div>
        <div class="crt-glow"></div>
        <div class="crt-glitch"></div>
    </div>
    <div class="fish-eye"></div>
    
    <div id="game-container">
        <div id="status-bar">
            <span id="credits"><span data-i18n="game.interface.credits">CREDITS:</span> <span id="credits-value">0</span></span>
            <span id="attention"><span data-i18n="game.interface.attention">ATTENTION:</span> <span id="attention-value">0</span><span data-i18n="game.interface.percent">%</span></span>
            <span id="visitors"><span data-i18n="game.interface.visitors">VISITORS:</span> <span id="visitors-value">0</span></span>
            <span id="satisfaction"><span data-i18n="game.interface.satisfaction">SATISFACTION:</span> <span id="satisfaction-value">100</span><span data-i18n="game.interface.percent">%</span></span>
            <span id="year">
                <span id="year-value" style="display:none;">2000</span>
                <div class="year-month-display">
                    <span class="year-display"></span>
                    <div class="month-boxes">
                        <div class="month-box" data-month="1"></div>
                        <div class="month-box" data-month="2"></div>
                        <div class="month-box" data-month="3"></div>
                        <div class="month-box" data-month="4"></div>
                        <div class="month-box" data-month="5"></div>
                        <div class="month-box" data-month="6"></div>
                        <div class="month-box" data-month="7"></div>
                        <div class="month-box" data-month="8"></div>
                        <div class="month-box" data-month="9"></div>
                        <div class="month-box" data-month="10"></div>
                        <div class="month-box" data-month="11"></div>
                        <div class="month-box" data-month="12"></div>
                    </div>
                </div>
            </span>
        </div>
        
        <div id="main-area">
            <div id="terminal">
                <div class="corner corner-tl"></div>
                <div class="corner corner-tr"></div>
                <div class="corner corner-bl"></div>
                <div class="corner corner-br"></div>
                
                <div id="terminal-output"></div>
                <div id="terminal-input">
                    <span class="prompt" data-i18n="game.interface.terminal_prompt">root@torrent:~$</span>
                    <input type="text" id="command-input" autocomplete="off">
                    <span class="blinking-cursor"></span>
                </div>
            </div>
            
            <div id="right-panel">
                <div id="event-log">
                    <div class="corner corner-tl"></div>
                    <div class="corner corner-tr"></div>
                    <div class="corner corner-bl"></div>
                    <div class="corner corner-br"></div>
                    
                    <h3 data-i18n="game.interface.event_log">EVENT LOG</h3>
                    <div id="events"></div>
                </div>
                
                <div id="site-rankings">
                    <div class="corner corner-tl"></div>
                    <div class="corner corner-tr"></div>
                    <div class="corner corner-bl"></div>
                    <div class="corner corner-br"></div>
                    
                    <h3 data-i18n="game.interface.rankings">RANKINGS</h3>
                    <div id="rankings-list">
                    </div>
                </div>
                
                <div id="netmap-container">
                    <div id="netmap">
                        <div class="corner corner-tl"></div>
                        <div class="corner corner-tr"></div>
                        <div class="corner corner-bl"></div>
                        <div class="corner corner-br"></div>
                        
                        <canvas id="netmap-canvas"></canvas>
                        
                        <div id="node-tooltip" style="display: none;"></div>
                        

                        
                        <div id="netmap-controls">
                            <div id="netmap-zoom">
                                <button id="zoom-in">+</button>
                                <button id="zoom-out">-</button>
                            </div>
                            <div id="netmap-threats">
                                <span data-i18n="game.interface.threats">Threats</span>: <span id="threat-count">0</span>
                            </div>
                        </div>
                        
                        <div id="netmap-title">
                            <span data-i18n="game.interface.netmap">NETMAP</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="taskbar">
        <div class="taskbar-content">
            <div class="taskbar-start">
                <div class="start-button" id="start-button">
                    <div class="start-icon">⚡</div>
                    <span class="start-text">EmpireOS</span>
                </div>
            </div>
            
            <div class="taskbar-apps">
                <div class="taskbar-app" data-command="marketplace">
                    <div class="app-icon">🛒</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="upload">
                    <div class="app-icon">📤</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="upgrades">
                    <div class="app-icon">⬆️</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="crack">
                    <div class="app-icon">🔨</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="ads">
                    <div class="app-icon">📢</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="panel">
                    <div class="app-icon">⚙️</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="website">
                    <div class="app-icon">🌐</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="anonchat">
                    <div class="app-icon">💬</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="mining">
                    <div class="app-icon">⛏️</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="files">
                    <div class="app-icon">📁</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="notepad">
                    <div class="app-icon">📝</div>
                    <div class="app-indicator"></div>
                </div>
                <div class="taskbar-app" data-command="music">
                    <div class="app-icon">🎵</div>
                    <div class="app-indicator"></div>
                </div>
            </div>
            
            <div class="taskbar-tray">
                <div class="taskbar-font-controls">
                    <button class="taskbar-font-btn" id="font-decrease">A-</button>
                    <button class="taskbar-font-btn" id="font-increase">A+</button>
                    <button class="taskbar-font-btn" id="font-reset">A</button>
                </div>
                
                <div class="tray-status" id="tray-status" title="System Status">
                    <div class="status-indicator active"></div>
                    <span class="status-text">ONLINE</span>
                    <?php if (isset($_SESSION['devmode_active']) && $_SESSION['devmode_active'] === true) { echo '<span class="taskbar-dev-icon" title="Dev Mode">🧪</span>'; } ?>
                </div>
                
                <div class="taskbar-clock" id="taskbar-clock">
                    <div class="clock-time" id="taskbar-time"></div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        let catAnimationInstance = null;

        document.addEventListener('DOMContentLoaded', function() {
            setInterval(() => {
                const cursor = document.querySelector('.blinking-cursor');
                if (cursor) {
                    cursor.style.opacity = cursor.style.opacity === '0' ? '1' : '0';
                }
            }, 500);
            
            const commandInput = document.getElementById('command-input');
            if (commandInput) {
                document.getElementById('terminal').addEventListener('click', () => {
                    commandInput.focus();
                });
            }
            
            setTimeout(() => {
                try {
                    const terminal = document.getElementById('terminal');
                    const terminalInput = document.getElementById('terminal-input');
                    
                    if (!terminal || !terminalInput) {
                        return;
                    }
                    
                    if (!catAnimationInstance) {
                        catAnimationInstance = new CatAnimation();
                        window.catAnimationInstance = catAnimationInstance;
                    }
                } catch (e) {
                    console.error('Cat animation could not be initialized:', e);
                }
            }, 1000);
        });
    </script>
</body>
</html> 